/*
 *******************************************************
 application:		Fuzzer Server
 author:		Ollie (ollie@atstake.com)
 version:		0.1
 known bugs &
 design issues:		
 			none
 to-do:
 			none
 changlog:		
 			23rd January 2002 - First version
 notes:
 *******************************************************
*/
#ifdef _WIN32
#include <Winsock2.h>
#include <Windows.h>
#define snprintf _snprintf
#else
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#endif
#include <stdio.h>



/*
 *******************************************************
 Declaration: Varibles
 *******************************************************
*/
unsigned int   headernum = 6, html=1;
int	       fuzzbuzzsize=5000;
unsigned char  headercontent[7][500] = {
		"HTTP/1.1 200 OK\x0d\x0a",
	        
	        "Date: Fri, 25 Jan 2002 11:10:09 GMT",
	        
	        "\x0d\x0a" 
	        "Server: AtStake Server Fuzz/0.1",
	        
	        "\x0d\x0a"
	        "Connection: close",
	        
	        "\x0d\x0a"
	        "Last-modified: Tue, 06 Feb 2001 10:37:29 GMT",
	        
	        "\x0d\x0a"
	        "Content-length: 506",
	        
	        "\x0d\x0a"
	        "Accept-ranges: bytes\x0d\x0a"
		};
	
unsigned char   contenttype[2][500] = {
		"Content-type: text/html\x0d\x0a\x0d\x0a",
		"Content-type: text/vnd.wap.wml\x0d\x0a\x0d\x0a"
		};
	
unsigned char   content[2][500] = {
		"<HTML><HEAD><TITLE> @stake fuzz server </TITLE></HEAD><CENTER>@stake Server Fuzzer<BR>(c)2002 @stake Inc </A><BR><CENTER>",
		"\x0d\x0a"
		"<?xml version=\"1.0\"?>"
		"\x0d\x0a"
		"<!DOCTYPE wml PUBLIC \"-//WAPFORUM//DTD WML 1.1//EN\" \"http://www.wapforum.org/DTD/wml_1.1.xml\">"
		"\x0d\x0a"
		"<wml><template>"
		"\x0d\x0a"
     		"<do type=\"prev\" name=""previous"" label=\"Back\">"
     		"\x0d\x0a"
         	"<prev/>"
         	"\x0d\x0a"
      		"</do>"
      		"\x0d\x0a"
		"</template>"
		"\x0d\x0a"
		"<card id=\"card0\" ontimer=\"http://foooooooooooo\" title=\"atstake\">"
		"\x0d\x0a"
        	"<timer value=\"50\"/>"
        	"\x0d\x0a"
        	"<p align='center'>"
        	"\x0d\x0a"
        	"<b>Welcome to</b>"
        	"\x0d\x0a"
        	"<br/>atstake fuzzer server<br/><br/>"
        	"\x0d\x0a"
		"<a href=\"http://fooooooooo\">Continue</a></p>"
		"\x0d\x0a"
		"</card>"
		"\x0d\x0a"
		"</wml>"
		};
	
/*
 *******************************************************
 Junk WAP Response
 *******************************************************

*/

/*
 *******************************************************
 Declaration: Functions
 *******************************************************
*/
void responsefuzz(int sock, char datype[4], char field[4] );
void oprint(char *bufdump,int buflen);
void usage();

/*
 *******************************************************
 Function: Main
 *******************************************************
*/
main (int argc, char *argv[])
{
	int reqlen,X, sp=0,rcvbufsize, packetlen, ret, sc, s;
	struct hostent *nametocheck;
	struct sockaddr_in serv_addr;
	struct in_addr attack;
	unsigned char buf[4096];
	char fuzztype[4];
	char fuzzfield[4];
	unsigned short SERVERPORT = 8011;
	
#ifdef _WIN32
	WORD werd;
	WSADATA wsd;
	werd=MAKEWORD(2,0);
#endif

	printf("~!~!~!~!~!~!~!~!~!~!~!~!~\n");
	printf("@stake fuzz server v0.1\n");
	printf("(c)2002 @stake inc\n");
	printf("author: ollie\n");
	printf("~!~!~!~!~!~!~!~!~!~!~!~!~\n");
	
	/* Param check */
	if(argv[1] != NULL){
		if (strcmp(argv[1],"wml")==0){
			html=0;
		}
	}
	if (html==1){
		printf("info: html output\n");
	}else{
		printf("info: wml output\n");
	}
	
	/* Param check */
	if(argv[2] != NULL){
		SERVERPORT=atoi(argv[2]);
	}
	printf("info: listening on port %d\n",SERVERPORT);
	
	if (argv[3] != NULL){
		fuzzbuzzsize=atoi(argv[3]);
	}
	printf("info: bufferoverflow size %d bytes\n",fuzzbuzzsize);
	
	
	
	
	/* Initialise Winsock in this thread for Win32 */
#ifdef _WIN32
	ret = WSAStartup( werd, &wsd );
	printf("info: calling wsastartup\n");	
	
	if ( ret != 0 ){
		printf("error: failed WSAStartUp.\n");
		return 0;
	}
	
	if ( LOBYTE( wsd.wVersion ) != 2 || HIBYTE( wsd.wVersion ) != 0 ) {
		printf("error: wVersion check failed.\n");
		return 0;
	}
#endif
	
	
	/* IP parameters */
	s = socket( AF_INET, SOCK_STREAM, 0 );
	printf("info: socket allocated\n");	
	/*
	if ( s != 0 ){
		printf("error: socket allocation failed\n");
		return 0;
	}
	*/
	
	serv_addr.sin_port = htons( SERVERPORT );	
	serv_addr.sin_family=AF_INET;
	serv_addr.sin_addr.s_addr = INADDR_ANY;

	ret = bind( s, (struct sockaddr *)&serv_addr, sizeof( struct sockaddr ) );
	printf("info: bound to port\n");	
	if ( ret != 0 ){
		printf("error: bind to port failed\n");
		return 0;
	}

	ret = listen( s, 128 );
	printf("info: listening\n");	
	if ( ret != 0 ){
		printf("error: listen failed\n");
		return 0;
	}
	
	printf("info: entering main loop\n");	
	/* Main loop for connects and requests */
	while( 1 )
	{
		/* Accept connection */
		sc = accept( s, NULL, NULL );
		/*
		if ( sc != 0 ){	
			printf("error: accept failed\n");
			return 0;
		}
		*/

		/* Recieve data */
		ret = recv( sc, buf, 4090, 0 );
		printf("info: got request\n");
		/* oprint(buf,ret); */
		
		/*
		if ( ret != 0 ){
			printf("error: recieve failed\n");
			goto exit;
		}
		*/

		buf[ret] = 0;
		if ( ret <= 14 ){
			printf("error: request to short\n");
			goto exit;
		}

		/* Check the request is a GET */
		if ( buf[0] != 'G' ){
			printf("error: didn't recieve a GET request\n");
			goto exit;
		}
		
		/* Check type of fuzz requested */
		strcpy(fuzztype,"buff");	
		strcpy(fuzzfield,"server");	
		
		if ( buf[5] == 'f'){
			printf("info: selected fuzz type of format string\n");
			strcpy(fuzztype,"fmt");
		}if ( buf[5] == 'b'){
			printf("info: selected fuzz type of overflow\n");
			strcpy(fuzztype,"buff");
		}
			
		if  ( buf[6] == 'd'){
			printf("info: fuzz field - date\n");
			strcpy(fuzzfield,"date");
		}if ( buf[6] == 's'){
			printf("info: fuzz field - server\n");
			strcpy(fuzzfield,"srvr");
		}if ( buf[6] == 'c'){
			printf("info: fuzz field - connection\n");
			strcpy(fuzzfield,"conn");
		}if ( buf[6] == 'm'){
			printf("info: fuzz field - last mod\n");
			strcpy(fuzzfield,"lmod");
		}if ( buf[6] == 'l'){
			printf("info: fuzz  field - length\n");
			strcpy(fuzzfield,"leng");
		}
			
		// fuzz what was asked to be fuzzed
		responsefuzz(sc,fuzztype,fuzzfield);
		goto exit;

	exit:
		printf("info: closing socket\n");
		#ifdef _WIN32
			closesocket(sc); 
		#else
			close(sc);
		#endif
	}
	printf("info: exiting......\n");
	return 0;
}


/*
 *******************************************************
 Function: responsefuzz
 Role	 : fuzzer head reponses as if from a web server
 Takes	 : socket
 Notes	 : 
 *******************************************************
*/
void responsefuzz(sock, datype, field)
	int sock;
	char datype[4];
	char field[4];
{
	int inttemp, cnttmp=0;
	char *strtemp;
	char *fuzzbuzz;

	printf("info: starting fuzz function\n");	
	/* build the buffer */
	printf("info: doing memset or format string stuff\n");
	
	if (strcmp(datype,"buff")==0){
		fuzzbuzz=malloc(fuzzbuzzsize);
		memset(fuzzbuzz,0x00,fuzzbuzzsize);
		memset(fuzzbuzz,0x41,fuzzbuzzsize-1);
	}if(strcmp(datype,"fmt")==0){
		fuzzbuzz=malloc(fuzzbuzzsize);
		memset(fuzzbuzz,0x00,fuzzbuzzsize);
		strcpy(fuzzbuzz,"%s%x%n%s%x%n%s%x%n%s%x%n%s%x%n%s%x%n%s%x%n%s%x%n%s%x%n%s%x%n");
	}
	
	printf("info: adding values for malloc\n");
	/* add up the header lengths */
	while (cnttmp<=headernum){
		inttemp=inttemp + strlen(headercontent[cnttmp]);
		cnttmp++;
	}
	
	/* check if we are sending WML or HTML and add to the content length for malloc*/
	if (html==1){
		inttemp=inttemp+strlen(contenttype[0]);
		inttemp=inttemp+strlen(content[0]);
		
	}else{
		inttemp=inttemp+strlen(contenttype[1]);
		inttemp=inttemp+strlen(content[1]);
	}
	
	/* add the fuzzbuzz buffer len */
	inttemp=inttemp + strlen(fuzzbuzz);
	
	/* do malloc */
	printf("info: mallocing\n");
	strtemp = malloc(inttemp);
	
	
	/* build response */
	cnttmp=0;
	while (cnttmp<=headernum){
		strcat(strtemp,headercontent[cnttmp]);
		if (cnttmp>0 && cnttmp<=headernum){
		   /* printf("info: checking which response to add\n"); */
		   
		   if (cnttmp==1 && strcmp(field,"date")==0){
		   	strcat(strtemp,fuzzbuzz);
		   }else if (cnttmp==2 && strcmp(field,"srvr")==0){
		   	strcat(strtemp,fuzzbuzz);
		   }else if (cnttmp==3 && strcmp(field,"conn")==0){
		   	strcat(strtemp,fuzzbuzz);
		   }else if (cnttmp==4 && strcmp(field,"lmod")==0){
		   	strcat(strtemp,fuzzbuzz);
		   }else if (cnttmp==5 && strcmp(field,"leng")==0){
		   	strcat(strtemp,fuzzbuzz);
		   }
		   
		  
		}
		cnttmp++;
	}
	
	printf("info: added content\n");
	/* check if we are sending WML or HTML and append to the headers*/
	if (html==1){
		strcat(strtemp,contenttype[0]);
		strcat(strtemp,content[0]);
		printf("info: adding html headers & content\n");
	}else{
		strcat(strtemp,contenttype[1]);
		strcat(strtemp,content[1]);
		printf("info: adding wml headers & content\n");
	}
	
	printf("info: sending response\n");
	send( sock, strtemp, strlen(strtemp), 0 );
	
	printf("info: doing free\n");
	free(strtemp);
	printf("info: doing free\n");
	free(fuzzbuzz);
}

/*
 *******************************************************
 Function: oprint
 Role	 : hex dumps said buffer
 Takes	 : buffer and length
 Notes	 : names inspired by hobbits oprint from netcat
 *******************************************************
*/
void oprint(bufdump,buflen)
	int buflen;
	char bufdump[2000];
{
	int c=0,c2=0;
		
	while (c <= buflen)
	{
		if (c2==16)
		{
			c2=c - 16;
			while (c2<c)
			{
				if (bufdump[c2] > 31 && bufdump[c2]<127)
					printf("%c",bufdump[c2]);
				else
					printf(".");
				c2++;
			}
			printf("\n");
			c2=0;
		}
		printf("%0.2x",bufdump[c] & 0xff);
		printf(" ");
		c++;
		c2++;
	}

	if(c2 != 1)
	{
		while(c2 < 16)
		{
			printf("   ");
			c2++;
			c++;
		}
		c2 = c - 16;
		while(c2 <= buflen)
		{
			if (bufdump[c2] > 31 && bufdump[c2]<127)
				printf("%c",bufdump[c2]);
			else
				printf(".");
			c2++;
		}
	}

	return;
}

/*
 *******************************************************
 Function: Usage
 Role	 : Prints out help screen
 *******************************************************
*/
void usage()
{
	printf("\n");
	printf("[server params]\n");
	printf("type [wml/html]	  - required\n");
	printf("port		  - optional\n");
	printf("syntax:	  fuzzer-server <type> <port>\n");
	printf("example:  fuzzer-server html 80\n");
	printf("\n[then within the client]\n");
	printf("configure the client to use the proxy/wap gatway you want to test then\n");
	printf("send a request such as http://IP.OF.SERVER.FUZZ/<type><field>\n\n");
	printf("type [f/b]	  - format string or overflow\n");
	printf("field 		  - http header field\n");
	printf("	      [d] - date last modified\n");
	printf("	      [s] - server\n");
	printf("	      [c] - connection\n");
	printf("	      [m] - last modified\n");
	printf("	      [l] - length\n\n");
	printf("	      [l] - length\n\n");
	printf("http://10.50.1.1/bd\n");		
	exit(1);
}